const pollutionScale = [
    {
      scale: [0, 50],
      quality: "Good",
      src: "happy",
      background: "linear-gradient(to right, #45B649, #DCE35B)",
    },
    {
      scale: [51, 100],
      quality: "Moderate",
      src: "thinking",
      background: "linear-gradient(to right, #F3F9A7, #CAC531)",
    },
    {
      scale: [101, 150],
      quality: "Unhealthy",
      src: "unhealthy",
      background: "linear-gradient(to right, #F16529, #E44D26)",
    },
    {
      scale: [151, 200],
      quality: "Bad",
      src: "bad",
      background: "linear-gradient(to right, #ef473a, #cb2d3e)",
    },
    {
      scale: [201, 300],
      quality: "Very bad",
      src: "mask",
      background: "linear-gradient(to right, #8E54E9, #4776E6)",
    },
    {
      scale: [301, 500],
      quality: "Terrible",
      src: "terrible",
      background: "linear-gradient(to right, #7a2828, #a73737)",
    },
  ];

const chargement = document.querySelector(".chargement");
const emoji = document.querySelector(".emoji")
const userInfo = document.querySelector(".user-info");

async function pollutionData(){
    try{
        const response = await fetch("http://api.airvisual.com/v2/nearest_city?key=7b1c1ff6-142e-43ea-accf-70f0283279dc").catch(error =>{
            throw new Error(error);
        })

        if(!response.ok){
            throw new Error(`Error ${response.status}, ${response.statusText}`)
        }

        console.log(response);

        const responseData = await response.json();
        const aqi = responseData.data.current.pollution.aqius;
        console.log(responseData)

        const sortie = {
            city: responseData.data.city,
            aqi, 
            ...pollutionScale.find(obj => aqi >= obj.scale[0] && aqi <= obj.scale[1])
        }
        console.log(sortie);
        populateUI(sortie);
    }
    catch(error){
        chargement.classList.remove("actif");
        emoji.src = "./ressources/browser.svg";
        userInfo.textContent = error.message;
    }
}
pollutionData()

const ville = document.querySelector(".ville");
const polluInfo = document.querySelector(".pollu-info");
const polluValue = document.querySelector(".pollu-value");
const layer = document.querySelector(".background-layer");

function populateUI(data){
    emoji.src = `ressources/${data.src}.svg`;
    userInfo.textContent = `Situation de : ${data.city}`;
    ville.textContent = data.city;
    polluInfo.textContent = data.quality;
    polluValue.textContent = data.aqi;
    layer.style.backgroudImage = data.background;
    chargement.classList.remove("actif")
    pointeurPosition(data.aqi);
}

const pointeur = document.querySelector(".pointeur");

function pointeurPosition(aqiValue){
    const parentWidth = pointeur.parentElement.scrollWidth;
    aqiValue/500
    aqiValue/500 * parentWidth
    pointeur.style.transform = `translateX(${aqiValue / 500 * parentWidth}px) rotate(180deg)`
}